//
//  NSString+Twitch.m
//  Twitch
//
//  Created by Auston Stewart on 4/4/14.
//  Copyright (c) 2014 Twitch Interactive, Inc. All rights reserved.
//

#import "NSString+Twitch.h"

@implementation NSString (Twitch)

- (NSString *)tw_stringByAbridgingGameTitle
{
	if (self.length > 16) {
		
		NSUInteger location = [self rangeOfString:@":"].location;
		if (location != NSNotFound) return [self substringToIndex:location];
	}
	
	return [NSString stringWithString:self];
}

- (NSString *)tw_stringByAbridgingGameTitleToLength:(NSUInteger)length
{
	if (self.length <= length) return [self copy];
	
	NSUInteger location = [self rangeOfString:@":"].location;
	if (location != NSNotFound && location < length) return [self substringToIndex:location];
	
	return [NSString stringWithFormat:@"%@…",[self substringToIndex:length - 1]];
}

- (NSRange)tw_rangeOfStringSpecifier:(NSUInteger)specifier
{
	NSString *searchString = [NSString stringWithFormat:@"%%%lu$@",(unsigned long)specifier];
	return [self rangeOfString:searchString];
}

@end
